/*
 * Decompiled with CFR 0.152.
 */
package com.sync.syncman.pm;

import com.sync.syncman.pm.ProcMgr;
import com.sync.syncman.pm.SMEvent;
import com.sync.syncman.pm.SMListener;
import com.sync.syncman.pm.ShowDataEvent;
import com.sync.syncman.pm.ShowDataListener;
import com.sync.syncman.pm.ShowHelpPageEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Vector;

class EventDispatcher
extends Thread {
    private static final int MAX_PACKET = 1024;
    private DatagramSocket sock;
    private DatagramPacket packet;
    private DataInputStream is;

    public EventDispatcher() {
        super("Sync/Man Event Dispatcher");
        byte[] byArray = new byte[1024];
        this.packet = new DatagramPacket(byArray, byArray.length);
        this.is = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            this.sock = new DatagramSocket();
            return;
        }
        catch (Exception exception) {
            this.sock = null;
            System.out.println("Exception: " + exception + '\n');
            return;
        }
    }

    public int getEventPort() {
        return this.sock.getLocalPort();
    }

    private void processEvent() {
        try {
            this.is.reset();
            int n = this.is.readInt();
            if (n == SMEvent.WM_PMACTIVATE || n == SMEvent.WM_CLOSENOW) {
                Vector vector = (Vector)ProcMgr.smListeners.clone();
                int n2 = 0;
                while (n2 < vector.size()) {
                    SMListener sMListener = (SMListener)vector.elementAt(n2);
                    if (n == SMEvent.WM_PMACTIVATE) {
                        sMListener.pmActivate(new SMEvent(this, n));
                    } else if (n == SMEvent.WM_CLOSENOW) {
                        sMListener.closeNow(new SMEvent(this, n));
                    }
                    ++n2;
                }
                return;
            }
            if (n == SMEvent.WM_SHOW_HELP_PAGE && ProcMgr.helpListener != null) {
                String string = this.is.readUTF();
                ShowHelpPageEvent showHelpPageEvent = new ShowHelpPageEvent(this, n, string);
                ProcMgr.helpListener.showHelpPage(showHelpPageEvent);
                return;
            }
            if (n == SMEvent.WM_SHOW_DATA) {
                int n3 = this.is.readInt();
                int[] nArray = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = this.is.readInt();
                    ++n4;
                }
                ShowDataEvent showDataEvent = new ShowDataEvent(this, n, nArray);
                Vector vector = (Vector)ProcMgr.showDataListeners.clone();
                n4 = 0;
                while (n4 < vector.size()) {
                    ShowDataListener showDataListener = (ShowDataListener)vector.elementAt(n4);
                    showDataListener.showData(showDataEvent);
                    ++n4;
                }
                return;
            }
            if (n != -1) {
                System.out.println("ProcMgr: Unknown event " + n);
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException + '\n');
        }
    }

    public void run() {
        while (ProcMgr.registered) {
            try {
                this.packet.setLength(1024);
                this.sock.receive(this.packet);
                this.processEvent();
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException + '\n');
            }
        }
        this.sock.close();
    }
}

